/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.hmm;

import java.util.Arrays;

class Betha {
    private final double[][] betha;
    private final double[] betha_scal;

    Betha(double[][] dist_prob, float[][] trans) {
        int T = dist_prob.length;
        int N = dist_prob[0].length;
        this.betha = new double[T][N];
        this.betha_scal = new double[T];
        Arrays.fill(this.betha[T - 1], 1.0 / (double)N);
        this.betha_scal[T - 1] = N;
        for (int t = T - 1; t > 0; --t) {
            int i;
            double[] betha_t = this.betha[t];
            double[] betha_t1 = this.betha[t - 1];
            double[] dist_prob_t = dist_prob[t];
            double betha_scal_t1 = 0.0;
            for (i = 0; i < N; ++i) {
                float[] trans_i = trans[i];
                double sum = 1.435E-42f;
                for (int j = 0; j < N; ++j) {
                    sum += (double)trans_i[j] * dist_prob_t[j] * betha_t[j];
                }
                betha_t1[i] = sum;
                betha_scal_t1 += betha_t1[i];
            }
            i = 0;
            while (i < N) {
                int n = i++;
                double d = betha_scal_t1;
                this.betha_scal[t - 1] = d;
                betha_t1[n] = betha_t1[n] / d;
            }
        }
        assert (Betha.testBetha(this.betha, this.betha_scal));
    }

    private static boolean testBetha(double[][] betha, double[] betha_scal) {
        int t_max = betha.length;
        for (int t = 0; t < t_max; ++t) {
            assert (!Double.isNaN(betha_scal[t]));
            assert (!Double.isInfinite(betha_scal[t]));
            assert (betha_scal[t] >= (double)1.4E-45f);
            double[] betha_t = betha[t];
            for (int i = 0; i < betha_t.length; ++i) {
                assert (!Double.isNaN(betha_t[i]));
                assert (!Double.isInfinite(betha_t[i]));
                assert (betha_t[i] >= (double)1.4E-45f);
            }
        }
        return true;
    }

    public double[][] getBetha() {
        return this.betha;
    }

    public double[] getBethaScal() {
        return this.betha_scal;
    }
}

