/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.mci;

import de.crysandt.audio.mpeg7audio.mci.Utils;
import java.net.URI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MediaLocator {
    private URI media_uri;
    private Integer stream_id;

    public MediaLocator(URI media_uri) {
        this.media_uri = media_uri;
        this.stream_id = null;
    }

    public Element toXML(Document doc, String name) {
        Element loc_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", name);
        loc_ele.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "MediaLocatorType");
        Element uri_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "MediaUri");
        Utils.setContent(doc, uri_ele, this.media_uri.toString());
        loc_ele.appendChild(uri_ele);
        if (this.stream_id != null) {
            Element str_id_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", "StreamID");
            Utils.setContent(doc, str_id_ele, this.stream_id.toString());
            loc_ele.appendChild(str_id_ele);
        }
        return loc_ele;
    }

    public URI getMediaUri() {
        return this.media_uri;
    }

    public int getStreamId() {
        return this.stream_id;
    }

    public void setMediaUri(URI uri) {
        this.media_uri = uri;
    }

    public void setStreamId(int id) {
        this.stream_id = new Integer(id);
    }
}

