/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.mci;

import de.crysandt.audio.mpeg7audio.mci.DescriptionSchemeI;
import de.crysandt.audio.mpeg7audio.mci.MediaLocator;
import de.crysandt.audio.mpeg7audio.mci.UniqueID;
import de.crysandt.audio.mpeg7audio.mci.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MediaInstance
implements DescriptionSchemeI {
    private UniqueID instance_identifier;
    private MediaLocator media_locator;
    private String location_description;

    public MediaInstance(UniqueID instance_identifier, MediaLocator media_locator) {
        this.instance_identifier = instance_identifier;
        this.media_locator = media_locator;
        this.location_description = null;
    }

    public MediaInstance(UniqueID instance_identifier, String location_description) {
        this.instance_identifier = instance_identifier;
        this.media_locator = null;
        this.location_description = location_description;
    }

    public Element toXML(Document doc, String name) {
        Element inst_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", name);
        inst_ele.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "MediaInstanceType");
        inst_ele.appendChild(this.instance_identifier.toXML(doc, "InstanceIdentifier"));
        if (this.media_locator != null) {
            inst_ele.appendChild(this.media_locator.toXML(doc, "MediaLocator"));
        } else {
            Element desc_ele = doc.createElement("LocationDescription");
            desc_ele.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "TextualType");
            Utils.setContent(doc, desc_ele, this.location_description);
            inst_ele.appendChild(desc_ele);
        }
        return inst_ele;
    }

    public UniqueID getInstanceIdentifier() {
        return this.instance_identifier;
    }

    public String getLocationDescription() {
        return this.location_description;
    }

    public MediaLocator getMediaLocator() {
        return this.media_locator;
    }

    public void setInstanceIdentifier(UniqueID identifier) {
        this.instance_identifier = identifier;
    }

    public void setLocationDescription(String desc) {
        if (desc != null) {
            this.location_description = desc;
            this.media_locator = null;
        }
    }

    public void setMediaLocator(MediaLocator locator) {
        if (locator != null) {
            this.media_locator = locator;
            this.location_description = null;
        }
    }
}

