/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.mci;

import de.crysandt.audio.mpeg7audio.mci.DescriptionSchemeI;
import de.crysandt.audio.mpeg7audio.mci.MediaHelper;
import de.crysandt.audio.mpeg7audio.mci.MediaIdentification;
import de.crysandt.audio.mpeg7audio.mci.MediaProfile;
import de.crysandt.util.Debug;
import de.crysandt.util.VectorTyped;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MediaInformation
implements DescriptionSchemeI {
    private MediaIdentification media_identity = null;
    private VectorTyped media_profiles = new VectorTyped(MediaProfile.class);

    public MediaInformation(MediaProfile profile) {
        this.media_profiles.add(profile);
    }

    public Element toXML(Document doc, String name) {
        Element info_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", name);
        info_ele.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "MediaInformationType");
        if (this.media_identity != null) {
            info_ele.appendChild(this.media_identity.toXML(doc, "MediaIdentification"));
        }
        for (int i = 0; i < this.media_profiles.size(); ++i) {
            info_ele.appendChild(((MediaProfile)this.media_profiles.get(i)).toXML(doc, "MediaProfile"));
        }
        return info_ele;
    }

    public MediaIdentification getMediaIdentification() {
        return this.media_identity;
    }

    public void setMediaIdentification(MediaIdentification media_identity) {
        this.media_identity = media_identity;
    }

    public VectorTyped getMediaProfiles() {
        return this.media_profiles;
    }

    public static void main(String[] args) {
        try {
            MediaInformation media_info = MediaHelper.createMediaInformation();
            MediaHelper.setMediaLocation(media_info, new File("test.mp3").toURI());
            MediaHelper.setContentType(media_info, 1);
            MediaHelper.setChannels(media_info, 2);
            MediaHelper.setSampleRate(media_info, 48000.0f);
            MediaHelper.setBitsPerSample(media_info, 16);
            MediaHelper.setBitRate(media_info, 196);
            MediaHelper.setBitRateVariable(media_info, true);
            MediaHelper.setBitRateMaximum(media_info, 320);
            MediaHelper.setBitRateMinimum(media_info, 128);
            MediaHelper.setBitRateAverage(media_info, 193);
            MediaHelper.setBandwidth(media_info, 20000.0f);
            DocumentBuilderFactory doc_factory = DocumentBuilderFactory.newInstance();
            doc_factory.setNamespaceAware(true);
            DocumentBuilder doc_builder = doc_factory.newDocumentBuilder();
            Document doc = doc_builder.newDocument();
            doc.appendChild(media_info.toXML(doc, "MediaInformation"));
            TransformerFactory trans_factory = TransformerFactory.newInstance();
            Transformer trans = trans_factory.newTransformer();
            trans.setOutputProperty("method", "xml");
            trans.setOutputProperty("indent", "yes");
            trans.transform(new DOMSource(doc), new StreamResult(new File("testMI.mp7")));
        }
        catch (Exception exc) {
            Debug.printStackTrace(System.err, exc);
        }
    }
}

