/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio.mci;

import de.crysandt.audio.mpeg7audio.mci.ControlledTermUse;
import de.crysandt.audio.mpeg7audio.mci.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MFAudioCoding {
    private ControlledTermUse format = null;
    private Integer audio_channels = null;
    private Integer audio_channels_front = null;
    private Integer audio_channels_side = null;
    private Integer audio_channels_rear = null;
    private Integer audio_channels_lfe = null;
    private Integer audio_channels_track = null;
    private Float sample_rate = null;
    private Integer sample_bits_per = null;
    private ControlledTermUse presentation = null;

    public Element toXML(Document doc, String name) {
        Element coding_ele = doc.createElementNS("urn:mpeg:mpeg7:schema:2001", name);
        if (this.format != null) {
            coding_ele.appendChild(this.format.toXML(doc, "Format"));
        }
        if (this.audio_channels != null || this.audio_channels_front != null || this.audio_channels_side != null || this.audio_channels_rear != null || this.audio_channels_lfe != null || this.audio_channels_track != null) {
            Element channels_ele = doc.createElement("AudioChannels");
            coding_ele.appendChild(channels_ele);
            if (this.audio_channels_front != null) {
                channels_ele.setAttribute("front", this.audio_channels_front.toString());
            }
            if (this.audio_channels_side != null) {
                channels_ele.setAttribute("side", this.audio_channels_side.toString());
            }
            if (this.audio_channels_rear != null) {
                channels_ele.setAttribute("rear", this.audio_channels_rear.toString());
            }
            if (this.audio_channels_lfe != null) {
                channels_ele.setAttribute("lfe", this.audio_channels_lfe.toString());
            }
            if (this.audio_channels_track != null) {
                channels_ele.setAttribute("track", this.audio_channels_track.toString());
            }
            if (this.audio_channels != null) {
                Utils.setContent(doc, channels_ele, this.audio_channels.toString());
            }
        }
        if (this.sample_rate != null || this.sample_bits_per != null) {
            Element sample_ele = doc.createElement("Sample");
            coding_ele.appendChild(sample_ele);
            if (this.sample_rate != null) {
                sample_ele.setAttribute("rate", this.sample_rate.toString());
            }
            if (this.sample_bits_per != null) {
                sample_ele.setAttribute("bitsPer", this.sample_bits_per.toString());
            }
        }
        if (this.presentation != null) {
            coding_ele.appendChild(this.presentation.toXML(doc, "Presentation"));
        }
        return coding_ele;
    }

    public int getAudioChannels() {
        return this.audio_channels;
    }

    public int getAudioChannelsFront() {
        return this.audio_channels_front;
    }

    public int getAudioChannelsLfe() {
        return this.audio_channels_lfe;
    }

    public int getAudioChannelsRear() {
        return this.audio_channels_rear;
    }

    public int getAudioChannelsSide() {
        return this.audio_channels_side;
    }

    public int getAudioChannelsTrack() {
        return this.audio_channels_track;
    }

    public ControlledTermUse getFormat() {
        return this.format;
    }

    public ControlledTermUse getPresentation() {
        return this.presentation;
    }

    public int getSampleBitsPer() {
        return this.sample_bits_per;
    }

    public float getSampleRate() {
        return this.sample_rate.floatValue();
    }

    public void setAudioChannels(int audio_channels) {
        this.audio_channels = new Integer(audio_channels);
    }

    public void setAudioChannelsFront(int front) {
        this.audio_channels_front = new Integer(front);
    }

    public void setAudioChannelsLfe(int lfe) {
        this.audio_channels_lfe = new Integer(lfe);
    }

    public void setAudioChannelsRear(int rear) {
        this.audio_channels_rear = new Integer(rear);
    }

    public void setAudioChannelsSide(int side) {
        this.audio_channels_side = new Integer(side);
    }

    public void setAudioChannelsTrack(int track) {
        this.audio_channels_track = new Integer(track);
    }

    public void setFormat(ControlledTermUse format) {
        this.format = format;
    }

    public void setPresentation(ControlledTermUse presentation) {
        this.presentation = presentation;
    }

    public void setSampleBitsPer(int bits) {
        this.sample_bits_per = new Integer(bits);
    }

    public void setSampleRate(float rate) {
        this.sample_rate = new Float(rate);
    }
}

