/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrum;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrumFlatness;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;

class AudioSpectrumFlatness
extends MsgSpeaker
implements MsgListener {
    private static final float RESOLUTION = 0.25f;
    private static final float OVERLAP = 0.05f;
    private float LO_EDGE;
    private float HI_EDGE;

    public AudioSpectrumFlatness(float samplerate, float lo_edge, float hi_edge) {
        this.LO_EDGE = lo_edge;
        this.HI_EDGE = hi_edge;
        while ((double)samplerate / 2.0 < (double)this.HI_EDGE) {
            this.HI_EDGE /= 2.0f;
        }
    }

    public AudioSpectrumFlatness(float lo_edge, float hi_edge) {
        this.LO_EDGE = lo_edge;
        this.HI_EDGE = hi_edge;
    }

    public void receivedMsg(Msg msg) {
        if (msg instanceof MsgAudioSpectrum) {
            this.receivedMsg((MsgAudioSpectrum)msg);
        }
    }

    public void receivedMsg(MsgAudioSpectrum mas) {
        float[] spectrum = mas.getAudioSpectrum();
        float delta_f = mas.deltaF;
        int num_bands = (int)(Function.log2(this.HI_EDGE / this.LO_EDGE) / 0.25f);
        float[] flatness = new float[num_bands];
        float band_factor = (float)Math.pow(2.0, 0.25);
        int m = (int)(Function.log2(this.LO_EDGE / 1000.0f) / 0.25f);
        for (int l = 0; l < flatness.length; ++l) {
            float[] ps;
            float freq = (float)(1000.0 * Math.pow(2.0, (float)m * 0.25f));
            float freq_lo = 0.95f * freq;
            float freq_hi = Math.min(1.05f * freq * band_factor, this.HI_EDGE);
            int i_lo = Math.round(freq_lo / delta_f);
            int i_hi = Math.round(freq_hi / delta_f) + 1;
            if (m < 0) {
                ps = new float[i_hi - i_lo];
                System.arraycopy(spectrum, i_lo, ps, 0, ps.length);
            } else {
                int grp = (int)Math.pow(2.0, 1.0 + Math.floor(m / 4));
                int num = Math.round((float)(i_hi - i_lo) / (float)grp);
                ps = new float[num];
                for (int n = 0; n < ps.length; ++n) {
                    ps[n] = spectrum[i_lo + n * grp];
                    for (int g = 1; g < grp; ++g) {
                        try {
                            int n2 = n;
                            ps[n2] = ps[n2] + spectrum[i_lo + n * grp + g];
                            continue;
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            // empty catch block
                        }
                    }
                }
            }
            float am = Function.mean_arith(ps);
            if ((double)am > 0.0) {
                int n = 0;
                while (n < ps.length) {
                    int n3 = n++;
                    ps[n3] = ps[n3] / am;
                }
                am = 1.0f;
                float gm = Function.mean_geom(ps);
                flatness[l] = gm / am;
            } else {
                flatness[l] = 1.0f;
            }
            ++m;
        }
        this.send(new MsgAudioSpectrumFlatness(mas.time, mas.hopsize, flatness, this.LO_EDGE, this.HI_EDGE));
    }
}

