/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioSpectrum;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;
import it.univpm.deit.FFT2N;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

class AudioSpectrum
extends MsgSpeaker
implements MsgListener {
    private static final int LENGTH_WINDOW = 30;
    private final float samplerate;
    private LinkedList msglist = new LinkedList();
    private Map hamming = new TreeMap();
    private Map fft2n = new TreeMap();

    public AudioSpectrum(float samplerate) {
        this.samplerate = samplerate;
    }

    private float[] getHamming(int length) {
        Integer key = new Integer(length);
        float[] window = (float[])this.hamming.get(key);
        if (window == null) {
            window = new float[length];
            for (int n = 0; n < window.length; ++n) {
                window[n] = (float)(0.54 - 0.46 * Math.cos((double)n * 2.0 * Math.PI / (double)(window.length - 1)));
            }
            this.hamming.put(key, window);
        }
        return window;
    }

    private FFT2N getFFT2N(int length_fft) {
        Integer key = new Integer(length_fft);
        FFT2N fft = (FFT2N)this.fft2n.get(key);
        if (fft == null) {
            fft = new FFT2N(length_fft);
            this.fft2n.put(key, fft);
        }
        return fft;
    }

    public void receivedMsg(Msg mr) {
        if (mr instanceof MsgResizer) {
            this.receivedMsg((MsgResizer)mr);
        }
    }

    public void receivedMsg(MsgResizer mr) {
        this.msglist.addLast(mr);
        if (30 % mr.duration != 0) {
            throw new AssertionError();
        }
        if (this.msglist.size() * mr.duration == 30) {
            float[] signal;
            int length = 0;
            Iterator i = this.msglist.iterator();
            while (i.hasNext()) {
                length += ((MsgResizer)i.next()).getSignalLength();
            }
            float[] s = new float[length];
            i = this.msglist.iterator();
            int index = 0;
            while (i.hasNext()) {
                float[] source = ((MsgResizer)i.next()).getSignal();
                System.arraycopy(source, 0, s, index, source.length);
                index += source.length;
            }
            float[] window = this.getHamming(s.length);
            for (int n = 0; n < window.length; ++n) {
                int n2 = n;
                s[n2] = s[n2] * window[n];
            }
            int length_fft = 1 << Function.getHighestBit(s.length - 1) + 1;
            FFT2N fft = this.getFFT2N(length_fft);
            if (length_fft == s.length) {
                signal = s;
            } else {
                signal = new float[length_fft];
                System.arraycopy(s, 0, signal, 0, s.length);
                Arrays.fill(signal, s.length, signal.length, 0.0f);
            }
            fft.fft(signal);
            float[] ps = FFT2N.PowerSpectrum(signal);
            MsgResizer msgresizer = (MsgResizer)this.msglist.get(0);
            this.send(new MsgAudioSpectrum(msgresizer.time, msgresizer.duration, window.length, fft.length, this.samplerate / (float)fft.length, ps));
            this.msglist.removeFirst();
        }
    }
}

