/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio.mpeg7audio;

import de.crysandt.audio.mpeg7audio.msgs.Msg;
import de.crysandt.audio.mpeg7audio.msgs.MsgAudioPower;
import de.crysandt.audio.mpeg7audio.msgs.MsgListener;
import de.crysandt.audio.mpeg7audio.msgs.MsgResizer;
import de.crysandt.audio.mpeg7audio.msgs.MsgSpeaker;
import de.crysandt.math.Function;

class AudioPower
extends MsgSpeaker
implements MsgListener {
    private static final float QUANTIZATION_NOISE_16BIT = (float)Function.square(2.0 / Math.pow(2.0, 16.0)) / 12.0f;
    private final boolean log_scale;

    public AudioPower(boolean log_scale) {
        this.log_scale = log_scale;
    }

    public void receivedMsg(Msg m) {
        if (m instanceof MsgResizer) {
            this.receivedMsg((MsgResizer)m);
        }
    }

    private void receivedMsg(MsgResizer m) {
        float[] signal = m.getSignal();
        float power = 0.0f;
        for (int i = 0; i < signal.length; ++i) {
            power += signal[i] * signal[i];
        }
        power /= (float)signal.length;
        if (this.log_scale) {
            power = 10.0f / (float)Function.LOG10 * (float)Math.log(power + Float.MIN_VALUE);
        }
        this.send(new MsgAudioPower(m.time, m.duration, power, this.log_scale));
    }
}

