/*
 * Decompiled with CFR 0.152.
 */
package de.crysandt.audio;

import de.crysandt.audio.AudioInFloat;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioInFloatSampled
extends AudioInFloat {
    private final int SIGNAL_LENGTH;
    private DataInputStream dis = null;
    private final boolean is_mono;
    private final float sample_rate;
    private final int bits_per_sample;
    private final AudioFormat src_format;

    public AudioInFloatSampled(AudioInputStream ais, int signal_length) {
        this.SIGNAL_LENGTH = signal_length;
        this.src_format = ais.getFormat();
        AudioFormat format = ais.getFormat();
        if (format.isBigEndian() && format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            this.dis = new DataInputStream(new BufferedInputStream(ais));
        } else {
            int size_in_bits = format.getSampleSizeInBits();
            if (size_in_bits != 8 && size_in_bits != 16) {
                size_in_bits = 16;
            }
            format = new AudioFormat(format.getSampleRate(), size_in_bits, format.getChannels(), true, true);
            this.dis = new DataInputStream(new BufferedInputStream(AudioSystem.getAudioInputStream(format, ais)));
        }
        this.is_mono = format.getChannels() == 1;
        this.sample_rate = format.getSampleRate();
        this.bits_per_sample = format.getSampleSizeInBits();
    }

    public AudioInFloatSampled(AudioInputStream ais) {
        this(ais, 4096);
    }

    public AudioInFloatSampled(InputStream is) throws IOException, UnsupportedAudioFileException {
        this(AudioSystem.getAudioInputStream(is));
    }

    public AudioInFloatSampled(File file) throws IOException, UnsupportedAudioFileException {
        this(AudioSystem.getAudioInputStream(file));
    }

    public float[] get() {
        float[] buffer = new float[this.SIGNAL_LENGTH];
        int index = 0;
        try {
            float amplitude = 1 << this.bits_per_sample - 1;
            switch (this.bits_per_sample) {
                case 8: {
                    for (index = 0; index < buffer.length; ++index) {
                        buffer[index] = (float)this.dis.readByte() / amplitude;
                    }
                    break;
                }
                case 16: {
                    for (index = 0; index < buffer.length; ++index) {
                        buffer[index] = (float)this.dis.readShort() / amplitude;
                    }
                    break;
                }
                default: {
                    throw new IllegalArgumentException(this.bits_per_sample + " bits/sample not supported");
                }
            }
        }
        catch (IOException e) {
            if (index == 0) {
                buffer = null;
            }
            float[] buffer_new = new float[index];
            System.arraycopy(buffer, 0, buffer_new, 0, buffer_new.length);
            buffer = buffer_new;
        }
        return buffer;
    }

    public AudioFormat getSourceFormat() {
        return this.src_format;
    }

    public float getSampleRate() {
        return this.sample_rate;
    }

    public boolean isMono() {
        return this.is_mono;
    }
}

