/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.externals.recognition.ui;

import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JToolBar;
import org.spantus.event.SpantusEvent;
import org.spantus.event.SpantusEventMulticaster;
import org.spantus.externals.recognition.ui.RecognitionCmdEnum;
import org.spantus.work.ui.ImageResourcesEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecognitionToolBar
extends JToolBar {
    private static final long serialVersionUID = 1L;
    private SpantusEventMulticaster eventMulticaster;
    ToolbarActionListener toolbarActionListener;
    private JButton recordBtn = null;
    private JButton stopBtn = null;
    private JCheckBox train;
    private boolean learnMode = false;

    public RecognitionToolBar(SpantusEventMulticaster eventMulticaster) {
        this.eventMulticaster = eventMulticaster;
    }

    public void initialize() {
        FlowLayout layout = new FlowLayout(0, 3, 2);
        this.setLayout(layout);
        this.add(this.getRecordBtn());
        this.add(this.getStopBtn());
        this.add(this.getTrainCheckbox());
    }

    public JButton getRecordBtn() {
        if (this.recordBtn == null) {
            ImageIcon icon = this.createIcon(ImageResourcesEnum.record.getCode());
            this.recordBtn = this.createButton(icon, RecognitionCmdEnum.record);
        }
        return this.recordBtn;
    }

    public JButton getStopBtn() {
        if (this.stopBtn == null) {
            ImageIcon icon = this.createIcon(ImageResourcesEnum.stop.getCode());
            this.stopBtn = this.createButton(icon, RecognitionCmdEnum.stop);
        }
        return this.stopBtn;
    }

    protected ImageIcon createIcon(String name) {
        URL url = this.getClass().getClassLoader().getResource(name);
        if (url == null) {
            return null;
        }
        ImageIcon ii = new ImageIcon(url);
        return new ImageIcon(ii.getImage().getScaledInstance(24, 24, 4));
    }

    public JCheckBox getTrainCheckbox() {
        if (this.train == null) {
            this.train = new JCheckBox(this.getResource(LabelEnum.train.name()));
            this.train.setSelected(this.learnMode);
            this.train.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    boolean learnMode = ((JCheckBox)e.getSource()).isSelected();
                    if (learnMode) {
                        RecognitionToolBar.this.getEventMulticaster().multicastEvent(SpantusEvent.createEvent((Object)this, (String)RecognitionCmdEnum.learn.name()));
                    } else {
                        RecognitionToolBar.this.getEventMulticaster().multicastEvent(SpantusEvent.createEvent((Object)this, (String)RecognitionCmdEnum.stopLearn.name()));
                    }
                }
            });
        }
        return this.train;
    }

    protected JButton createButton(ImageIcon icon, Enum<?> enumVal) {
        return this.createButton(icon, enumVal.name(), enumVal.name());
    }

    protected JButton createButton(ImageIcon icon, String cmd) {
        return this.createButton(icon, cmd, cmd);
    }

    protected JButton createButton(ImageIcon icon, String cmd, String name) {
        JButton btn = null;
        btn = icon == null ? new JButton(this.getResource(name), icon) : new JButton(icon);
        btn.setActionCommand(cmd);
        btn.setBorder(BorderFactory.createCompoundBorder());
        btn.setMargin(new Insets(0, 0, 0, 0));
        btn.setFocusable(false);
        btn.setActionCommand(cmd);
        btn.setToolTipText(this.getResource(name));
        btn.addActionListener(this.getToolbarActionListener());
        return btn;
    }

    public String getResource(String key) {
        return key;
    }

    public ToolbarActionListener getToolbarActionListener() {
        if (this.toolbarActionListener == null) {
            this.toolbarActionListener = new ToolbarActionListener();
        }
        return this.toolbarActionListener;
    }

    public boolean isLearnMode() {
        return this.learnMode;
    }

    public void setLearnMode(boolean learnMode) {
        this.learnMode = learnMode;
    }

    public SpantusEventMulticaster getEventMulticaster() {
        return this.eventMulticaster;
    }

    public void setEventMulticaster(SpantusEventMulticaster eventMulticaster) {
        this.eventMulticaster = eventMulticaster;
    }

    public class ToolbarActionListener
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            RecognitionToolBar.this.getEventMulticaster().multicastEvent(SpantusEvent.createEvent((Object)this, (String)e.getActionCommand()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LabelEnum {
        start,
        stop,
        train;

    }
}

