/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.externals.recognition.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.spantus.event.SpantusEvent;
import org.spantus.event.SpantusEventListener;
import org.spantus.event.SpantusEventMulticaster;
import org.spantus.externals.recognition.ui.AdminPanel;
import org.spantus.externals.recognition.ui.RecognitionCmdEnum;
import org.spantus.externals.recognition.ui.RecognitionMonitorPlot;
import org.spantus.externals.recognition.ui.RecognitionUIActionListenerImpl;

public class RecognitionPanel
extends JPanel
implements SpantusEventListener {
    private static final long serialVersionUID = 1L;
    private RecognitionMonitorPlot recognitionPlot;
    private AdminPanel adminPanel;
    private SpantusEventMulticaster eventMulticaster;

    public RecognitionPanel(SpantusEventMulticaster eventMulticaster) {
        this.setLayout(new BorderLayout());
        this.eventMulticaster = eventMulticaster;
        RecognitionUIActionListenerImpl actionListener = new RecognitionUIActionListenerImpl(this);
        eventMulticaster.addListener((SpantusEventListener)actionListener);
        eventMulticaster.addListener((SpantusEventListener)this);
    }

    public void initialize() {
        JSplitPane splitPane = new JSplitPane(0, true, (Component)((Object)this.getRecognitionPlot()), this.getAdminPanel());
        splitPane.setOneTouchExpandable(true);
        this.add(splitPane);
    }

    public RecognitionMonitorPlot getRecognitionPlot() {
        if (this.recognitionPlot == null) {
            this.recognitionPlot = new RecognitionMonitorPlot();
        }
        return this.recognitionPlot;
    }

    public AdminPanel getAdminPanel() {
        if (this.adminPanel == null) {
            this.adminPanel = new AdminPanel();
        }
        return this.adminPanel;
    }

    public void setRecognitionPlot(RecognitionMonitorPlot recognitionPlot) {
        this.recognitionPlot = recognitionPlot;
    }

    public void onEvent(SpantusEvent event) {
        String cmd = event.getCmd();
        if (!RecognitionCmdEnum.isCmd(cmd)) {
            return;
        }
        RecognitionCmdEnum recCmd = RecognitionCmdEnum.valueOf(cmd);
        switch (recCmd) {
            case learn: {
                this.getRecognitionPlot().setLearnMode(true);
                break;
            }
            case stopLearn: {
                this.getRecognitionPlot().setLearnMode(false);
                break;
            }
        }
    }

    public SpantusEventMulticaster getEventMulticaster() {
        return this.eventMulticaster;
    }

    public void setEventMulticaster(SpantusEventMulticaster eventMulticaster) {
        this.eventMulticaster = eventMulticaster;
    }
}

