/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.externals.recognition.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import org.spantus.externals.recognition.bean.CorpusFileEntry;
import org.spantus.externals.recognition.corpus.CorpusRepositoryFileImpl;
import org.spantus.externals.recognition.ui.CorpusEntryTableModel;
import org.spantus.logger.Logger;
import org.spantus.work.wav.AudioManagerFactory;

public class AdminPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private Logger log = Logger.getLogger(AdminPanel.class);
    private CorpusRepositoryFileImpl corpusRepository;
    private JToolBar toolbar;
    List<CorpusFileEntry> corpusFileEntries;

    public AdminPanel() {
        this.initialize();
    }

    private void initialize() {
        this.corpusFileEntries = this.getCorpusRepository().findAllFileEntries();
        this.setSize(640, 480);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.getTable()), "Center");
        this.add((Component)this.getToolbar(), "North");
    }

    private JTable getTable() {
        if (this.table == null) {
            this.table = new JTable(new CorpusEntryTableModel(this.corpusFileEntries));
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 70));
        }
        return this.table;
    }

    private JToolBar getToolbar() {
        if (this.toolbar == null) {
            this.toolbar = new JToolBar();
            this.toolbar.setLayout(new FlowLayout(0, 3, 2));
            JButton playBtn = new JButton("play");
            playBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AdminPanel.this.play();
                }
            });
            JButton saveCloseBtn = new JButton("save");
            saveCloseBtn.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AdminPanel.this.save();
                }
            });
            this.toolbar.add(saveCloseBtn);
            this.toolbar.add(playBtn);
        }
        return this.toolbar;
    }

    public void play() {
        if (this.getTable().getSelectedRow() >= 0) {
            CorpusFileEntry entry = this.corpusFileEntries.get(this.getTable().getSelectedRow());
            if (entry.getWavFile().exists()) {
                try {
                    AudioManagerFactory.createAudioManager().play(entry.getWavFile().toURI().toURL(), null, null);
                }
                catch (MalformedURLException e) {
                    this.log.error((Exception)e);
                }
            } else {
                this.log.debug("File not exists " + entry.getWavFile());
            }
        }
    }

    public void save() {
        for (CorpusFileEntry entry : this.corpusFileEntries) {
            this.getCorpusRepository().update(entry);
        }
    }

    public CorpusRepositoryFileImpl getCorpusRepository() {
        if (this.corpusRepository == null) {
            this.corpusRepository = new CorpusRepositoryFileImpl();
        }
        return this.corpusRepository;
    }
}

