/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.externals.recognition.services;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.spantus.externals.recognition.bean.CorpusEntry;
import org.spantus.externals.recognition.bean.FeatureData;
import org.spantus.externals.recognition.bean.RecognitionResult;
import org.spantus.externals.recognition.bean.RecognitionResultDetails;
import org.spantus.externals.recognition.corpus.CorpusRepository;
import org.spantus.externals.recognition.corpus.CorpusRepositoryFileImpl;
import org.spantus.externals.recognition.services.CorpusService;
import org.spantus.logger.Logger;
import org.spantus.math.dtw.DtwResult;
import org.spantus.math.dtw.DtwService;
import org.spantus.math.services.MathServicesFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorpusServiceBaseImpl
implements CorpusService {
    private Logger log = Logger.getLogger(this.getClass());
    private DtwService dtwService;
    private CorpusRepository corpus;

    @Override
    public RecognitionResult match(FeatureData featureData) {
        RecognitionResult match = this.findBestMatch(featureData);
        return match;
    }

    @Override
    public List<RecognitionResultDetails> findMultipleMatch(FeatureData target) {
        TreeMap<Float, RecognitionResultDetails> results = new TreeMap<Float, RecognitionResultDetails>();
        for (CorpusEntry sample : this.getCorpus().findAllEntries()) {
            RecognitionResultDetails result = new RecognitionResultDetails();
            result.setInfo(sample);
            DtwResult dtwResult = this.getDtwService().calculateInfoVector((List)target.getValues(), (List)sample.getFeatureMap().get(target.getName()).getValues());
            result.setDistance(dtwResult.getResult());
            result.setPath(dtwResult.getPath());
            results.put(result.getDistance(), result);
        }
        if (results.isEmpty()) {
            return new ArrayList<RecognitionResultDetails>();
        }
        return new ArrayList<RecognitionResultDetails>(results.values());
    }

    @Override
    public boolean learn(String label, FeatureData featureData) {
        CorpusEntry entry = new CorpusEntry();
        entry.setName(label);
        entry.getFeatureMap().put(featureData.getName(), featureData);
        this.getCorpus().save(entry);
        return true;
    }

    protected RecognitionResult findBestMatch(FeatureData target) {
        TreeMap<Float, RecognitionResult> results = new TreeMap<Float, RecognitionResult>();
        Float min = Float.valueOf(Float.MAX_VALUE);
        RecognitionResult match = null;
        for (CorpusEntry sample : this.getCorpus().findAllEntries()) {
            RecognitionResult res = this.compare(target, sample);
            if (min.floatValue() > res.getDistance().floatValue()) {
                min = res.getDistance();
                match = res;
            }
            if (!this.log.isDebugMode()) continue;
            results.put(res.getDistance(), res);
        }
        if (this.log.isDebugMode()) {
            this.log.debug("[findBestMatch] sample: {0};[{1}]", new Object[]{match, results});
        }
        this.log.info(MessageFormat.format("[findBestMatch] sample: {0};[{1}]", match, results.values()));
        return match;
    }

    protected RecognitionResult compare(FeatureData target, CorpusEntry sample) {
        RecognitionResult result = new RecognitionResult();
        result.setInfo(sample);
        result.setDistance(this.getDtwService().calculateDistanceVector((List)target.getValues(), (List)sample.getFeatureMap().get(target.getName()).getValues()));
        return result;
    }

    public void setCorpus(CorpusRepository corpus) {
        this.corpus = corpus;
    }

    public CorpusRepository getCorpus() {
        if (this.corpus == null) {
            this.corpus = new CorpusRepositoryFileImpl();
        }
        return this.corpus;
    }

    public DtwService getDtwService() {
        if (this.dtwService == null) {
            this.dtwService = MathServicesFactory.createDtwService();
        }
        return this.dtwService;
    }
}

