/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.externals.recognition.services;

import java.io.File;
import java.util.List;
import org.spantus.core.FrameVectorValues;
import org.spantus.core.extractor.IExtractor;
import org.spantus.core.extractor.IExtractorInputReader;
import org.spantus.core.extractor.IExtractorVector;
import org.spantus.core.extractor.IGeneralExtractor;
import org.spantus.logger.Logger;
import org.spantus.math.dtw.DtwService;
import org.spantus.math.services.MathServicesFactory;
import org.spantus.work.services.FeatureExtractor;
import org.spantus.work.services.FeatureExtractorImpl;
import org.spantus.work.services.ReaderDao;
import org.spantus.work.services.WorkServiceFactory;

public class CompareFeatures {
    private String workingExtractor = "LPC";
    private DtwService dtwService;
    private ReaderDao readerDao;
    private FeatureExtractor featureExtractor;
    private Logger log = Logger.getLogger(this.getClass());

    public Float compareValues(FrameVectorValues targetValues, File sampleFile) {
        IExtractorInputReader sampleReader = this.getExtractorInputReader(sampleFile);
        IGeneralExtractor sampleExtractor = this.getFeatureExtractor().findExtractorByName(this.getWorkingExtractor(), sampleReader);
        Float distance = this.calculateDistance(targetValues, sampleExtractor);
        return distance;
    }

    public Float compareValues(File targetFile, File sampleFile) {
        IExtractorInputReader sampleReader = this.getExtractorInputReader(sampleFile);
        IExtractorInputReader targetReader = this.getExtractorInputReader(targetFile);
        IGeneralExtractor sampleExtractor = this.getFeatureExtractor().findExtractorByName(this.getWorkingExtractor(), sampleReader);
        IGeneralExtractor targetExtractor = this.getFeatureExtractor().findExtractorByName(this.getWorkingExtractor(), targetReader);
        Float distance = this.calculateDistance(targetExtractor, sampleExtractor);
        return distance;
    }

    protected IExtractorInputReader getExtractorInputReader(File readerFile) {
        return this.getReaderDao().read(readerFile);
    }

    public Float calculateDistance(IGeneralExtractor targetExtractor, IGeneralExtractor sampleExtractor) {
        if (targetExtractor instanceof IExtractor) {
            return this.getDtwService().calculateDistance((List)((IExtractor)targetExtractor).getOutputValues(), (List)((IExtractor)sampleExtractor).getOutputValues());
        }
        if (targetExtractor instanceof IExtractorVector) {
            return this.getDtwService().calculateDistanceVector((List)((IExtractorVector)targetExtractor).getOutputValues(), (List)((IExtractorVector)sampleExtractor).getOutputValues());
        }
        return null;
    }

    public Float calculateDistance(FrameVectorValues targetValues, IGeneralExtractor sampleExtractor) {
        return this.getDtwService().calculateDistanceVector((List)targetValues, (List)((IExtractorVector)sampleExtractor).getOutputValues());
    }

    public static void main(String[] args) {
        String samplePath = "./test/du.sspnt.xml";
        String targetPath = "./test/vienas.sspnt.xml";
        File sampleFile = new File(samplePath);
        File targetFile = new File(targetPath);
        CompareFeatures compareFeatures = new CompareFeatures();
        Float f = compareFeatures.compareValues(targetFile, sampleFile);
        System.out.print("[main] comparition result: " + f);
    }

    public FeatureExtractor getFeatureExtractor() {
        if (this.featureExtractor == null) {
            this.featureExtractor = new FeatureExtractorImpl();
        }
        return this.featureExtractor;
    }

    public DtwService getDtwService() {
        if (this.dtwService == null) {
            this.dtwService = MathServicesFactory.createDtwService();
        }
        return this.dtwService;
    }

    public ReaderDao getReaderDao() {
        if (this.readerDao == null) {
            this.readerDao = WorkServiceFactory.createReaderDao();
        }
        return this.readerDao;
    }

    public String getWorkingExtractor() {
        return this.workingExtractor;
    }
}

