/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.externals.recognition.services;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.spantus.core.FrameVectorValues;
import org.spantus.externals.recognition.services.CompareFeatures;
import org.spantus.externals.recognition.services.CompareFeaturesCachable;
import org.spantus.logger.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BestMatch {
    private CompareFeatures compareFeatures;
    private List<File> sampleRepo;
    private Logger log = Logger.getLogger(this.getClass());
    private String rootPath = "./sviesa_isjunk_viskas/";

    public void findBestMatch(File targetFile) {
        TreeMap<Float, String> result = new TreeMap<Float, String>();
        Float minDistance = Float.valueOf(Float.MAX_VALUE);
        String minDisntanceName = "";
        for (File sampleFile : this.getSampleRepo()) {
            Float distance = this.getCompareFeatures().compareValues(sampleFile, targetFile);
            result.put(distance, sampleFile.getName());
            if (Math.min(minDistance.floatValue(), distance.floatValue()) != distance.floatValue() || distance.floatValue() == 0.0f) continue;
            minDistance = distance;
            minDisntanceName = sampleFile.getName();
        }
        this.log.debug("[findBestMatch] sample: {0};[{1}]", new Object[]{minDisntanceName, result});
    }

    public String findBestMatch(FrameVectorValues targetValues) {
        TreeMap<Float, String> result = new TreeMap<Float, String>();
        Float minDistance = Float.valueOf(Float.MAX_VALUE);
        String minDisntanceName = "";
        for (File sampleFile : this.getSampleRepo()) {
            Float distance = this.getCompareFeatures().compareValues(targetValues, sampleFile);
            result.put(distance, sampleFile.getName());
            if (Math.min(minDistance.floatValue(), distance.floatValue()) != distance.floatValue() || distance.floatValue() == 0.0f) continue;
            minDistance = distance;
            minDisntanceName = sampleFile.getName();
        }
        this.log.debug("[findBestMatch] sample: {0};[{1}]", new Object[]{minDisntanceName, result});
        return minDisntanceName;
    }

    public static void main(String[] args) {
        BestMatch bestMatch = new BestMatch();
        File targetFile = new File("./target/11118.sspnt.xml");
        bestMatch.findBestMatch(targetFile);
    }

    public CompareFeatures getCompareFeatures() {
        if (this.compareFeatures == null) {
            this.compareFeatures = new CompareFeaturesCachable();
        }
        return this.compareFeatures;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public List<File> getSampleRepo() {
        if (this.sampleRepo == null) {
            this.sampleRepo = new ArrayList<File>();
            File repoDir = new File(this.getRootPath());
            if (repoDir.isDirectory()) {
                for (String fileName : repoDir.list()) {
                    if (!fileName.endsWith(".sspnt.xml")) continue;
                    this.sampleRepo.add(new File(repoDir, fileName));
                }
            }
        }
        return this.sampleRepo;
    }
}

