/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.externals.recognition.segment;

import java.net.URL;
import org.spantus.core.FrameVectorValues;
import org.spantus.core.extractor.IExtractorVector;
import org.spantus.core.marker.Marker;
import org.spantus.externals.recognition.bean.FeatureData;
import org.spantus.externals.recognition.bean.RecognitionResult;
import org.spantus.externals.recognition.corpus.CorpusMatchListener;
import org.spantus.externals.recognition.services.CorpusService;
import org.spantus.externals.recognition.services.CorpusServiceBaseImpl;
import org.spantus.logger.Logger;
import org.spantus.segment.io.RecordSegmentatorOnline;
import org.spantus.work.services.FeatureExtractor;
import org.spantus.work.services.FeatureExtractorImpl;

public class RecordRecognitionSegmentatorOnline
extends RecordSegmentatorOnline {
    private CorpusService corpusService;
    private FeatureExtractorImpl featureExtractor;
    private CorpusMatchListener corpusMatchListener;
    private Boolean learnMode = Boolean.FALSE;
    private Logger log = Logger.getLogger(RecordRecognitionSegmentatorOnline.class);

    public URL processAcceptedSegment(Marker marker) {
        URL path = super.processAcceptedSegment(marker);
        this.findBestMatach(marker);
        return path;
    }

    protected void findBestMatach(Marker marker) {
        for (IExtractorVector extractor : this.getReader().getReader().getExtractorRegister3D()) {
            FrameVectorValues values = extractor.getOutputValues();
            Float fromIndex = Float.valueOf(marker.getStart().floatValue() * values.getSampleRate() / 1000.0f);
            Float toIndexF = Float.valueOf(fromIndex.floatValue() + marker.getLength().floatValue() * values.getSampleRate() / 1000.0f);
            Integer toIndex = toIndexF.intValue();
            if (toIndex > values.size()) {
                toIndex = values.size();
            }
            FrameVectorValues fvv = values.subList(fromIndex.intValue(), toIndex.intValue());
            FeatureData featureData = new FeatureData();
            featureData.setName(extractor.getName());
            featureData.setValues(fvv);
            if (this.getLearnMode().booleanValue()) {
                this.getCorpusService().learn(marker.getLabel(), featureData);
                continue;
            }
            RecognitionResult result = this.getCorpusService().match(featureData);
            if (result != null) {
                marker.setLabel(result.getInfo().getName());
                continue;
            }
            this.log.info("[findBestMatach] there is no match");
        }
        this.log.info("[findBestMatach]" + marker);
    }

    protected void notifyCorpusMatchListener(RecognitionResult result, Marker marker) {
        if (result != null) {
            marker.setLabel(result.getInfo().getName());
        }
        if (this.getCorpusMatchListener() != null) {
            this.getCorpusMatchListener().matched(result);
        }
    }

    public CorpusService getCorpusService() {
        if (this.corpusService == null) {
            this.corpusService = new CorpusServiceBaseImpl();
        }
        return this.corpusService;
    }

    public FeatureExtractor getFeatureExtractor() {
        if (this.featureExtractor == null) {
            this.featureExtractor = new FeatureExtractorImpl();
        }
        return this.featureExtractor;
    }

    public Boolean getLearnMode() {
        return this.learnMode;
    }

    public void setLearnMode(Boolean learnMode) {
        this.learnMode = learnMode;
    }

    public CorpusMatchListener getCorpusMatchListener() {
        return this.corpusMatchListener;
    }

    public void setCorpusMatchListener(CorpusMatchListener corpusMatchListener) {
        this.corpusMatchListener = corpusMatchListener;
    }
}

