/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.externals.recognition.segment;

import org.spantus.core.FrameVectorValues;
import org.spantus.core.extractor.IExtractorInputReader;
import org.spantus.core.extractor.IExtractorVector;
import org.spantus.core.marker.Marker;
import org.spantus.externals.recognition.bean.FeatureData;
import org.spantus.externals.recognition.bean.RecognitionResult;
import org.spantus.externals.recognition.services.CorpusService;
import org.spantus.externals.recognition.services.CorpusServiceBaseImpl;
import org.spantus.extractor.ExtractorInputReader;
import org.spantus.logger.Logger;
import org.spantus.segment.online.DecisionSegmentatorOnline;
import org.spantus.work.services.FeatureExtractor;
import org.spantus.work.services.FeatureExtractorImpl;

public class RecognitionSegmentatorOnline
extends DecisionSegmentatorOnline {
    private ExtractorInputReader bufferedReader;
    private FeatureExtractor featureExtractor;
    private CorpusService corpusService;
    private Logger log = Logger.getLogger(((Object)((Object)this)).getClass());
    private Boolean learnMode = Boolean.FALSE;

    protected boolean onSegmentEnded(Marker marker) {
        if (!super.onSegmentEnded(marker)) {
            return false;
        }
        for (IExtractorVector extractor : this.bufferedReader.getExtractorRegister3D()) {
            FrameVectorValues values = extractor.getOutputValues();
            Float fromIndex = Float.valueOf(marker.getStart().floatValue() * values.getSampleRate() / 1000.0f);
            Float toIndex = Float.valueOf(fromIndex.floatValue() + marker.getLength().floatValue() * values.getSampleRate() / 1000.0f);
            FrameVectorValues fvv = values.subList(fromIndex.intValue(), toIndex.intValue());
            FeatureData featureData = new FeatureData();
            featureData.setName(extractor.getName());
            featureData.setValues(fvv);
            if (this.getLearnMode().booleanValue()) {
                this.getCorpusService().learn(marker.getLabel(), featureData);
                continue;
            }
            RecognitionResult result = this.getCorpusService().match(featureData);
            if (result == null) {
                this.log.error("Does not matched");
                continue;
            }
            marker.setLabel(this.getCorpusService().match(featureData).getInfo().getName());
        }
        this.log.error(marker.toString());
        return true;
    }

    public FeatureExtractor getFeatureExtractor() {
        if (this.featureExtractor == null) {
            this.featureExtractor = new FeatureExtractorImpl();
        }
        return this.featureExtractor;
    }

    public IExtractorInputReader getBufferedReader() {
        return this.bufferedReader;
    }

    public CorpusService getCorpusService() {
        if (this.corpusService == null) {
            this.corpusService = new CorpusServiceBaseImpl();
        }
        return this.corpusService;
    }

    public Boolean getLearnMode() {
        return this.learnMode;
    }

    public RecognitionSegmentatorOnline(ExtractorInputReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }
}

