/*
 * Decompiled with CFR 0.152.
 */
package org.spantus.externals.recognition.corpus;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.enums.EnumConverter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.spantus.exception.ProcessingException;
import org.spantus.externals.recognition.bean.CorpusEntry;
import org.spantus.externals.recognition.bean.CorpusFileEntry;
import org.spantus.externals.recognition.corpus.CorpusRepository;
import org.spantus.logger.Logger;
import org.spantus.utils.FileUtils;
import org.spantus.work.services.converter.FrameValues3DConverter;
import org.spantus.work.services.converter.FrameValuesConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorpusRepositoryFileImpl
implements CorpusRepository {
    private XStream xstream;
    private static Logger log = Logger.getLogger(CorpusRepositoryFileImpl.class);
    private File repoDir = null;
    public static final String CORPUS_ENTRY_FILE_EXT = ".cspnt.xml";
    public static final String DEFAULT_REPO_PATH = "./target/corpus";
    List<CorpusEntry> repo;

    @Override
    public List<CorpusEntry> findAllEntries() {
        if (this.repo == null) {
            this.repo = new ArrayList<CorpusEntry>();
            if (this.getRepoDir().isDirectory()) {
                for (String fileName : this.repoDir.list()) {
                    if (!fileName.endsWith(CORPUS_ENTRY_FILE_EXT)) continue;
                    this.repo.add(this.read(new File(this.repoDir, fileName)));
                }
            }
        }
        return this.repo;
    }

    public List<CorpusFileEntry> findAllFileEntries() {
        ArrayList<CorpusFileEntry> repoFiles = new ArrayList<CorpusFileEntry>();
        if (this.getRepoDir().isDirectory()) {
            for (String fileName : this.getRepoDir().list()) {
                if (!fileName.endsWith(CORPUS_ENTRY_FILE_EXT)) continue;
                repoFiles.add(this.readFileEntry(new File(this.repoDir, fileName)));
            }
        }
        return repoFiles;
    }

    @Override
    public void save(CorpusEntry entry) {
        this.saveFile(entry);
        this.repo = null;
    }

    public File saveFile(CorpusEntry entry) {
        File file;
        if (entry.getId() == null) {
            entry.setId(System.currentTimeMillis());
        }
        if ((file = new File(this.getRepoDir(), entry.getName() + CORPUS_ENTRY_FILE_EXT)).exists()) {
            file = new File(this.getRepoDir(), entry.getName() + "-" + System.currentTimeMillis() + CORPUS_ENTRY_FILE_EXT);
        }
        try {
            FileWriter outputFile = new FileWriter(file, false);
            this.getXsteam().toXML((Object)entry, (Writer)outputFile);
        }
        catch (IOException e) {
            log.error((Exception)e);
        }
        return file;
    }

    public void update(CorpusFileEntry entry) {
        String entryName;
        String wavName;
        File file = null;
        if (entry.getEntryFile().exists()) {
            entry.getEntryFile().delete();
            file = this.saveFile(entry.getCorpusEntry());
        }
        if (entry.getWavFile().exists() && !(wavName = FileUtils.stripExtention((File)entry.getWavFile())).equals(entryName = FileUtils.stripExtention((String)FileUtils.stripExtention((String)file.getName())))) {
            File dest = new File(entry.getWavFile().getParent(), entryName + ".wav");
            entry.getWavFile().renameTo(dest);
        }
    }

    protected CorpusEntry read(File entryFile) {
        CorpusEntry entry = null;
        try {
            FileReader inFile = new FileReader(entryFile);
            entry = (CorpusEntry)this.getXsteam().fromXML((Reader)inFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        return entry;
    }

    protected CorpusFileEntry readFileEntry(File entryFile) {
        CorpusFileEntry fileEntry = null;
        try {
            FileReader inFile = new FileReader(entryFile);
            CorpusEntry corpusEntry = (CorpusEntry)this.getXsteam().fromXML((Reader)inFile);
            fileEntry = new CorpusFileEntry();
            fileEntry.setCorpusEntry(corpusEntry);
            fileEntry.setEntryFile(entryFile);
            File wavFile = new File(entryFile.getParent(), FileUtils.stripExtention((String)FileUtils.stripExtention((File)entryFile)) + ".wav");
            fileEntry.setWavFile(wavFile);
        }
        catch (FileNotFoundException e) {
            throw new ProcessingException((Throwable)e);
        }
        return fileEntry;
    }

    protected XStream getXsteam() {
        if (this.xstream == null) {
            this.xstream = new XStream();
            this.xstream.registerConverter((Converter)new EnumConverter());
            this.xstream.registerConverter((Converter)new FrameValuesConverter());
            this.xstream.registerConverter((Converter)new FrameValues3DConverter());
        }
        return this.xstream;
    }

    public File getRepoDir() {
        if (this.repoDir == null) {
            this.repoDir = FileUtils.checkDirs((String)DEFAULT_REPO_PATH);
        }
        return this.repoDir;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repoDir = FileUtils.checkDirs((String)repositoryPath);
    }
}

